# -*- coding: utf-8 -*-
import xbmcaddon
import xbmcgui
import os
import re
import urllib
import requests
from bs4 import BeautifulSoup
import simplejson as json
import sys
import xbmc

KodiV = xbmc.getInfoLabel('System.BuildVersion')
KodiV = int(KodiV[:2])

class zamunda():
  def __init__(
                self,
                xxx,
                muz,
                base_url,
                usr,
                passwd,
                path,
                checkimdb,
                baud = 0,
                bsub = 0,
                dbg = False,
                ):
    self.__usr = usr
    self.__pass = passwd
    self.__s = requests.Session()
    self.__base_url = base_url
    self.__checkimdb = checkimdb
    self.__bsub = bsub
    self.__baud = baud
    self.__dbg = dbg
    self.__CUSTOM_TRACKERS = (
      ('tr', 'http://tracker.zamunda.net/announce.php?passkey=95b29926c5b7adab4a133cfc490ed0aa'),
      ('tr', 'http://tracker.zamunda.net/announce.php?passkey=92149dad63bdd68fedffcd44d27209dc'),
      ('tr', 'http://flashtorrents.org/announce.php'),
      ('tr', 'http://94.228.192.98/announce'),
      ('tr', 'udp://9.rarbg.com:2710/announce')
    )
    self.__categories = [
                    {'cat_ids':'5','cat_name':u'HD Movies'},
                    {'cat_ids':'19','cat_name':u'Movies XviD'},
                    {'cat_ids':'42','cat_name':u'Blu-ray'},
                    {'cat_ids':'35','cat_name':u'Movies x264'},
                    {'cat_ids':'24','cat_name':u'Bg Movies'},
                    {'cat_ids':'25','cat_name':u'Animation'},
                    {'cat_ids':'28','cat_name':u'Russian Movies'},
                    {'cat_ids':'31','cat_name':u'Science Movies'},
                    {'cat_ids':'7','cat_name':u'Series'},
                    {'cat_ids':'33','cat_name':u'HD Series'},
                    {'cat_ids':'55','cat_name':u'Russian Series'},
                    {'cat_ids':'41','cat_name':u'Sport'},
                    {'cat_ids':'43','cat_name':u'HD Sport'},
                    {'cat_ids':'23','cat_name':u'Clips/Concerts'},
                  ]

    self.__HEADERS = {
      'Host' : self.__base_url.split('//')[1],
      'User-Agent' : 'Mozilla/5.0 (X11; Ubuntu; Linux x86_64; rv:32.0) Gecko/20100101 Firefox/32.0'
    }
    
    if muz == True:
      self.__categories += [
                              {'cat_ids':'30','cat_name':u'Music DTS'},
                              {'cat_ids':'29','cat_name':u'Music DVD-R'},
                              {'cat_ids':'51','cat_name':u'Music Hi-Res/Vinyl'},
                              {'cat_ids':'34','cat_name':u'Music Lossless'},
                            ]

    if xxx == True:
      self.__categories += [
                              {'cat_ids':'9','cat_name':u'XXX'},
                              {'cat_ids':'27','cat_name':u'Hentai XXX'},
                              {'cat_ids':'49','cat_name':u'HD XXX'}
                            ]

    self.__ids = [d['cat_ids'] for d in self.__categories]

    self.__s_path = os.path.join(path, '', 'sesion')
    if not os.path.exists(os.path.dirname(self.__s_path)):
      os.makedirs(os.path.dirname(self.__s_path))
    if not os.path.exists(self.__s_path):
      self.__log('Use Login')
      self.__do_login()
      with open(self.__s_path, 'w') as f:
        json.dump(
                    requests.utils.dict_from_cookiejar(self.__s.cookies),
                    f,
                    sort_keys=True,
                    indent=True,
                    encoding='utf-8',
                  )
    else:
      self.__log('Use Sessinon')
      with open(self.__s_path, 'rb') as f:
        self.__s.cookies = requests.utils.cookiejar_from_dict(json.load(f))

  def __del__(self):
    if getattr(self, '_use_log', None):
      self.__do_logout()
    self.__log('Exit')
    self.__s.close()

  def __log(self, msg):
    if self.__dbg:
      if isinstance(msg, basestring):
        print (msg.encode('utf-8'))
      else:
        print (str(msg))

  def __do_logout(self):
    self.__log('Logout')
    self.__s.get('%s/logout.php' % self.__base_url, headers = self.__HEADERS)

  def __do_login(self):
    r = self.__s.post('%s/takelogin.php' % self.__base_url, data={'username' : self.__usr, 'password' : self.__pass}, headers = self.__HEADERS)
    if r.status_code == requests.codes.ok and re.search(self.__usr, r.text, re.IGNORECASE):
      self.__log('Login OK')
      self._use_log = True
      return True
    else:
      self.__log('Login Error')
      raise Exception("LoginFail")

  def __info_get(self, txt):
    if txt:
      txt = re.sub(r"Tip\('|\\'|'\)", '', txt)
      ff = BeautifulSoup(txt, 'html5lib')
      tempthumb = ff.find('img').get('src')
      searchz = re.search('zamunda',tempthumb)
      if searchz:
          thumb = tempthumb
      else:
          thumb = self.__base_url + ff.find('img').get('src')
      return {'img': thumb,'info': re.sub( r'(?:\s+)', ' ', ff.get_text(' '))}
    else:
      return {'img': 'DefaultVideo.png', 'info': ''}
      
  def __info_getRel(self, txt):
    if txt:
      txt = re.sub(r"Tip\('|\\'|'\)", '', txt)
      ff = BeautifulSoup(txt, 'html.parser')
      Release = re.sub( r'(?:\s+)', ' ', ff.get_text(' '))
      Release = Release.replace(u'Свали: ','')
      Release = Release.replace(u'Свали:','')
      f_release = ''
      if len(Release)>30:
          redove = len(Release)/30
          f_release = u'\n[COLOR CC00FF00]Релийз:[/COLOR]\n' + Release[:30]
          for x in range(int(redove)):
              f_release = f_release + '\n' + Release[30*(x+1):30*(x+2)]
      else:
          f_release = u'\n[COLOR CC00FF00]Релийз:[/COLOR]\n' + Release
      return {'info': f_release}
    else:
      return {'info': ''}
      
  def __checkres(self, txt1, txt2):
    txt2 = txt2.replace('\n','')
    res2160 = re.search('2160',txt2)
    if res2160:
      res = '[COLOR CC00FF00]2160p[/COLOR]'
    else:
      res1080 = re.search('1080',txt2)
      if res1080:
        res = '[COLOR CC00FF00]1080p[/COLOR]'
      else:
        res720 = re.search('720',txt2)
        if res720:
          res = '[COLOR CC00FF00]720p[/COLOR]'
        else:
          resvalues = {'5':'HD','33':'HD','35':'HD','43':'HD','46':'3D','42':'Blu-ray','20':'DVD-R'}
          searchcat = re.search(r'list\?cat=\d+',str(txt1))
          cat = searchcat.group(0)
          cat = cat.replace('list?cat=','')
          try:
              res = '[COLOR CC00FF00]'+resvalues[cat]+'[/COLOR]'
          except:
              res = ''
    return{'resolution':res}

  def __claean_name(self, n):
    n_sub = [
              r'\s\[.*?\]',
              r'\s\/\s.*',
            ]
    self.__log(n)
    for _sub in n_sub:
      n = re.sub(_sub, '', n)
    self.__log(n)
    return n

  def index(self):
    yield {'label': u'Search', 'cat': '0', 'page': 0, 'search': '!search!', 'is_playable': 'False'}
    yield {'label': u'Favorites', 'cat': '999', 'page': 0, 'search': '!none!', 'is_playable': 'False'}
    yield {'label': u'Browse latest', 'cat': '0', 'page': 0, 'search': '!none!', 'is_playable': 'False'}
    for cat in self.__categories:
      yield {'label': cat['cat_name'],'cat': cat['cat_ids'], 'page': 0, 'search': '!none!', 'is_playable': 'False'}

  def page(self, page, cat, search=None):
    fnd = {
            'search': '',
            'incldead': '0',
            'in': 'name',
          }
    fnd['page'] = page
    fnd['cat'] = cat
    fnd['bgsubs'] = self.__bsub
    fnd['bgaudio'] = self.__baud
    

    if search != '!none!' and search != '!search!':
      fnd['search'] =  search.encode('cp1251')
      self.__log('Search string: %s' % (search,))

    self.__log('Payload: %s' % (str(fnd),))
    if cat == '999':
        r = self.__s.get('https://zamunda.net/favorites/?field=name&page='+str(page), headers = self.__HEADERS)
    else:
        r = self.__s.get('%s/bananas' % self.__base_url, params=fnd, headers = self.__HEADERS)


    if self.__dbg:
       with open(os.path.join(os.path.dirname(self.__s_path), '', 'dump.html'), 'wb') as f:
         f.write(r.text.encode('utf-8'))

    if r.status_code != requests.codes.ok:
      self.__log('Page Error')
      raise Exception("PageError")

    if not re.search(self.__usr, r.text, re.IGNORECASE):
      if os.path.exists(self.__s_path):
        os.remove(self.__s_path)
      self.__log('Sesion Error')
      raise Exception("SesionError")

    sp = BeautifulSoup(r.text, 'html5lib')
    #filepath='D:/cat.m3u'
    #f_m3u =  open(filepath,'w')
    #f_m3u.write(r.text.encode('utf-8'))
    #f_m3u.close()
    #for link in sp.findAll('a', href=re.compile(r'\/download_go\.php\?id=\d+&m=x')):
    if cat=='999':
        for link in sp.findAll('a', href=re.compile(r'download_go\.php\?id=\d+&m=x')):
          pr = link.find_parent('td')
          if cat != '0' or pr.find_previous_sibling('td').find('a', href=re.compile(r'list\?cat=\d+'))['href'].split('=')[1] in self.__ids:
            ss = pr.find_next_siblings('td')
            dat = pr.find('a', href=re.compile(r'banan\?id=\d+'))
            r = self.__info_get(dat.get('onmouseover'))
            datRel = pr.find('a', href=re.compile(r'download_go\.php\?id=\d+'))
            rRel = self.__info_getRel(datRel.get('onmouseover'))
            checkbg = pr.find('img', src=re.compile(r'bgaudio.png'))
            if checkbg:
                BGAudio = u'\n[COLOR CC00FF00]BG Audio: [/COLOR]' + u'Да'
                CatAudio = '[COLOR CC00FF00]BG Audio[/COLOR]' 
            else:
                BGAudio = u'\n[COLOR CC00FF00]BG Audio: [/COLOR]' + u'Не'
                CatAudio = ''
            checkbgsubs = pr.find('img', src=re.compile(r'bgsubs.png'))
            if checkbgsubs:
                BGSubs = u'\n[COLOR CC00FF00]BG Subs: [/COLOR]' + u'Да'
                CatSubs = '[COLOR CC00FF00]BG Subs[/COLOR]'
            else:
                BGSubs = u'\n[COLOR CC00FF00]BG Subs: [/COLOR]' + u'Не'
                CatSubs = ''
            checkcatres = self.__checkres(pr.find_previous_sibling('td').find('a', href=re.compile(r'list\?cat=\d+')),rRel['info'])
            checkcat = checkcatres['resolution']
            checkcatlist = [checkcat,CatAudio,CatSubs]
            tempcheckcat = ''
            for c in range(len(checkcatlist)):
                if checkcatlist[c] == '':
                    pass
                else:
                    tempcheckcat = tempcheckcat + checkcatlist[c] + '|'
            checkcat = tempcheckcat[:-1]
            if checkcat == '':
                checkcat = ''
            else: 
                checkcat = '|[COLOR CC00FF00]'+checkcat+'[/COLOR]'
            new_magnet = '/magnetlink/' + link['href']
            
            #намираме IMDB ID
            if self.__checkimdb:
                r_imdb = self.__s.get('https://zamunda.net' + new_magnet, headers = self.__HEADERS)
                matchimdb = re.search('imdb.com/title/(.+?)"', r_imdb.text)
                if matchimdb:
                    imdb_id = matchimdb.group(1).replace('/','')
                else:
                    imdb_id = ""
            else:
                imdb_id = ""
            #край на намирането
            yield {
                'label': self.__claean_name(dat.string)+checkcat,
                'path': new_magnet,
                'is_playable': 'True',
                'info': {'plot': '[COLOR CC00FF00]%s - DLs:%s S:%s[/COLOR][CR]%s' % (ss[3].get_text(' '), ss[4].get_text(' '), ss[5].string, r['info']+"\n"+rRel['info']+"\n"+BGSubs+"\n"+BGAudio,)},
                'thumbnail': r['img'],
                'imdbid': imdb_id,
                'cat': cat,
                'page': page,
                'search': search,
                'properties': {'fanart_image': r['img']}
            }
    else:
        for link in sp.findAll('a', href=re.compile(r'\/magnetlink\/*')):
          pr = link.find_parent('td')
          if cat != '0' or pr.find_previous_sibling('td').find('a', href=re.compile(r'list\?cat=\d+'))['href'].split('=')[1] in self.__ids:
            
            ss = pr.find_next_siblings('td')
            dat = pr.find('a', href=re.compile(r'banan\?id=\d+'))
            r = self.__info_get(dat.get('onmouseover'))
            datRel = pr.find('a', href=re.compile(r'download.php\/\d+'))
            rRel = self.__info_getRel(datRel.get('onmouseover'))
            checkbg = pr.find('img', src=re.compile(r'bgaudio.png'))
            if checkbg:
                BGAudio = u'\n[COLOR CC00FF00]BG Audio: [/COLOR]' + u'Да'
                CatAudio = '[COLOR CC00FF00]BG Audio[/COLOR]'
            else:
                BGAudio = u'\n[COLOR CC00FF00]BG Audio: [/COLOR]' + u'Не'
                CatAudio = ''
            checkbgsubs = pr.find('img', src=re.compile(r'bgsubs.png'))
            if checkbgsubs:
                BGSubs = u'\n[COLOR CC00FF00]BG Subs: [/COLOR]' + u'Да'
                CatSubs = '[COLOR CC00FF00]BG Subs[/COLOR]'
            else:
                BGSubs = u'\n[COLOR CC00FF00]BG Subs: [/COLOR]' + u'Не'
                CatSubs = ''
            checkcatres = self.__checkres(pr.find_previous_sibling('td').find('a', href=re.compile(r'list\?cat=\d+')),rRel['info'])
            checkcat = checkcatres['resolution']
            checkcatlist = [checkcat,CatAudio,CatSubs]
            tempcheckcat = ''
            for c in range(len(checkcatlist)):
                if checkcatlist[c] == '':
                    pass
                else:
                    tempcheckcat = tempcheckcat + checkcatlist[c] + '|'
            checkcat = tempcheckcat[:-1]
            if checkcat == '':
                checkcat = ''
            else: 
                checkcat = '|[COLOR CC00FF00]'+checkcat+'[/COLOR]'
            #намираме IMDB ID
            if self.__checkimdb:
                r_imdb = self.__s.get('https://zamunda.net/' + link['href'], headers = self.__HEADERS)
                matchimdb = re.search('imdb.com/title/(.+?)"', r_imdb.text)
                if matchimdb:
                    imdb_id = matchimdb.group(1).replace('/','')
                else:
                    imdb_id = ""
            else:
                imdb_id = ""
            #край на намирането
            yield {
                'label': self.__claean_name(dat.string)+checkcat,
                'path': link['href'],
                'is_playable': 'True',
                'info': {'plot': '[COLOR CC00FF00]%s - DLs:%s S:%s[/COLOR][CR]%s' % (ss[3].get_text(' '), ss[4].get_text(' '), ss[5].string, r['info']+"\n"+rRel['info']+"\n"+BGSubs+"\n"+BGAudio,)},
                'thumbnail': r['img'],
                'imdbid': imdb_id,
                'cat': cat,
                'page': page,
                'search': search,
                'properties': {'fanart_image': r['img']}
            }
    nn = sp.find('b', text=re.compile(u'(?:Следваща.)'))
    if nn and nn.find_parent('a'):
      yield {
          'label': '>> Next page',
          'path': 'next_page',
          'cat': cat,
          'page': page+1,
          'is_playable': 'False',
          'search': search,
      }

  def get_magnet(self, p):
    magsearch = re.search('magnetlink',p)
    if magsearch:
        r = self.__s.get('%s%s' % (self.__base_url, p), headers = self.__HEADERS)
        
        m = re.search('magnet(.+?)"', r.text)
        
        if m:
            found = 'magnet' + m.group(1)
            if KodiV >= 19:
                return'%s&%s' % (found, urllib.parse.urlencode(self.__CUSTOM_TRACKERS),)
            else:
                return'%s&%s' % (found, urllib.urlencode(self.__CUSTOM_TRACKERS),)
    else:
        m = p
        if m:
            found = m
            if KodiV >= 19:
                return'%s&%s' % (found, urllib.parse.urlencode(self.__CUSTOM_TRACKERS),)
            else:
                return'%s&%s' % (found, urllib.urlencode(self.__CUSTOM_TRACKERS),)
