# -*- coding: utf-8 -*-
import os, sys

import xbmc
import xbmcaddon
import xbmcgui
import xbmcplugin
import urllib
import re
import xbmcvfs
#from ga import ga

KodiV = xbmc.getInfoLabel('System.BuildVersion')
KodiV = int(KodiV[:2])

__addon__ = xbmcaddon.Addon()
__author__ = __addon__.getAddonInfo('author')
__scriptid__ = __addon__.getAddonInfo('id')
__scriptname__ = __addon__.getAddonInfo('name')
__version__ = __addon__.getAddonInfo('version')
__language__ = __addon__.getLocalizedString

if KodiV >= 19:
    __icon__ = __addon__.getAddonInfo('icon')
    __cwd__ = xbmcvfs.translatePath( __addon__.getAddonInfo('path') )
    __profile__ = xbmcvfs.translatePath( __addon__.getAddonInfo('profile') )
    __resource__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'lib' ) )
    __icon_msg__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'zamunda.png' ) )
    __icon_search__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'search.png' ) )
    __icon_clear__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'clear.png' ) )
    __icon_fav__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'fav.png' ) )
    __icon_folders__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'movies.png' ) )
    __icon_sresult__ = xbmcvfs.translatePath( os.path.join( __cwd__, 'resources', 'search-result.png' ) )
else:
    __icon__ = __addon__.getAddonInfo('icon').decode('utf-8')
    __cwd__ = xbmc.translatePath( __addon__.getAddonInfo('path') ).decode('utf-8')
    __profile__ = xbmc.translatePath( __addon__.getAddonInfo('profile') ).decode('utf-8')
    __resource__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'lib' ) ).decode('utf-8')
    __icon_msg__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'zamunda.png' ) ).decode('utf-8')
    __icon_search__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'search.png' ) ).decode('utf-8')
    __icon_clear__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'clear.png' ) ).decode('utf-8')
    __icon_fav__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'fav.png' ) ).decode('utf-8')
    __icon_folders__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'movies.png' ) ).decode('utf-8')
    __icon_sresult__ = xbmc.translatePath( os.path.join( __cwd__, 'resources', 'search-result.png' ) ).decode('utf-8')
tplayer = xbmcaddon.Addon().getSetting('tplayer')

sys.path.insert(0, __resource__)

searchlist = __addon__.getSetting('searchlist')

checkepg = ['0']
def chepg(ch):
    ch.append('1')
    ch.remove('0')

def Notify (msg1, msg2):
  if KodiV >= 19:
      xbmc.executebuiltin((u'Notification(%s,%s,%s,%s)' % (msg1, msg2, '5000', __icon_msg__)))
  else:
      xbmc.executebuiltin((u'Notification(%s,%s,%s,%s)' % (msg1, msg2, '5000', __icon_msg__)).encode('utf-8'))

if __addon__.getSetting('firstrun') == 'true':
  Notify('Settings', 'empty')
  __addon__.openSettings()
  __addon__.setSetting('firstrun', 'false')

if __addon__.getSetting('dbg') == 'true':
  dbg = True
else:
  dbg = False

if __addon__.getSetting('bg_aud') == 'true':
  ba = 1
else:
  ba = 0

if __addon__.getSetting('bg_sub') == 'true':
  bs = 1
else:
  bs = 0

if __addon__.getSetting('muz') == 'true':
  muz = True
else:
  muz = False
  
if __addon__.getSetting('xxx') == 'true':
  xxx = True
else:
  xxx = False
  
if __addon__.getSetting('checkimdb') == 'true':
  checkimdb = True
else:
  checkimdb = False

if not __addon__.getSetting('username'):
  Notify('User', 'empty')
if not __addon__.getSetting('password'):
  Notify('Password', 'empty')

def update(name, dat, crash=None):
  payload = {}
  payload['an'] = __scriptname__
  payload['av'] = __version__
  payload['ec'] = name
  payload['ea'] = 'zamunda'
  payload['ev'] = '1'
  if KodiV >= 19:
      payload['dl'] = urllib.parse.quote_plus(dat)
  else:
      payload['dl'] = urllib.quote_plus(dat.encode('utf-8'))
  #ga().update(payload, crash)

import traceback
try:
  from zamunda import zamunda
  z = zamunda(
              xxx = xxx,
              muz = muz,
              base_url = __addon__.getSetting('base'),
              usr = __addon__.getSetting('username'),
              passwd = __addon__.getSetting('password'),
              baud = ba,
              bsub = bs,
              checkimdb = checkimdb,
              path = __profile__,
              dbg = dbg
            )
except Exception as e:
  if e.args[0] == 'LoginFail':
    Notify('LoginFail', 'Check login data')
  else:
    Notify('Module Import', 'Fail')
  traceback.print_exc()
  update('exception', e.args[0], sys.exc_info())
  raise

def index_video(page, cat, search):
  try:
    c = {}
    for c in z.page(
                    int(page),
                    cat,
                    search,
                  ):
      add_video(c)

  except Exception as e:
    if e.args[0] == 'SesionError':
      Notify(str(e.args[0]),  'Check login data and try again')
    else:
      Notify(__scriptname__, str(e.args[0]))

    traceback.print_exc()
    update('exception', '%s->%s' % (e.args[0], c.get('label', None)), sys.exc_info())
    pass

def index_cat():
  chepg(checkepg)
  c = {}
  try:
    for c in z.index():
      tsearch = str(c)
      chsearch = re.search('!search!',tsearch)
      chsearchF = re.search('Favorites',tsearch)
      if chsearch:
          add_cat(c, __icon_search__, __icon_search__)
      else:
          if chsearchF:
              add_cat(c, __icon_fav__, __icon_fav__)
          else:
              add_cat(c, __icon_folders__, __icon_folders__)

  except Exception as e:
    Notify(__scriptname__, str(e.args[0]))
    traceback.print_exc()
    update('exception', '%s->%s' % (e.args[0], c.get('label', None)), sys.exc_info())
    pass

def play_video(url, name):
  #p = 'plugin://plugin.video.yatp/?action=play&torrent=%s&file_index=dialog' % (z.get_magnet(url),)
  if '0' in tplayer:
    p = 'plugin://plugin.video.quasar/play?uri=%s' % (z.get_magnet(url),)
  if '1' in tplayer:
    p = 'plugin://plugin.video.elementum/play?uri=%s' % (z.get_magnet(url),)

  item = xbmcgui.ListItem(path=p)
  xbmcplugin.setResolvedUrl(int(sys.argv[1]), True, item)
  update(name, url)

def add_cat(cat, iconimage, fanart):
  if KodiV >= 19:
      u = sys.argv[0] + '?url=' + urllib.parse.quote_plus('ddd') + '&mode=' + str(2) + '&cat=' + urllib.parse.quote_plus(cat['cat']) + '&search=' + urllib.parse.quote_plus(cat['search'].encode('utf-8')) + '&page=' + urllib.parse.quote_plus(str(cat['page']))+"&iconimage="+urllib.parse.quote_plus(iconimage)
      liz=xbmcgui.ListItem(cat['label'])
  else:
      u = sys.argv[0] + '?url=' + urllib.quote_plus('ddd') + '&mode=' + str(2) + '&cat=' + urllib.quote_plus(cat['cat']) + '&search=' + urllib.quote_plus(cat['search'].encode('utf-8')) + '&page=' + urllib.quote_plus(str(cat['page']))
      liz=xbmcgui.ListItem(cat['label'], iconImage='DefaultFolder.png', thumbnailImage=iconimage)
  
  liz.setArt({ 'thumb': iconimage,'poster': iconimage, 'banner' : iconimage, 'fanart': iconimage })
  liz.setInfo( type='Video', infoLabels={ 'Title': cat['label']})
  liz.setProperty('fanart_image', fanart)
  return xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=True)

def add_video(dat):
  if dat['path'] != 'next_page':
    if KodiV >= 19:
        u = sys.argv[0] + '?url=' + urllib.parse.quote_plus(dat['path']) + '&mode=' + str(1) + '&cat=' + urllib.parse.quote_plus(dat['cat']) + '&name=' + urllib.parse.quote_plus(dat['label'].encode('utf-8')) + '&search=' + urllib.parse.quote_plus(dat['search'].encode('utf-8')) + '&page=' +urllib.parse.quote_plus(str(dat['page']))
        liz = xbmcgui.ListItem(dat['label'])
    else:
        u = sys.argv[0] + '?url=' + urllib.quote_plus(dat['path']) + '&mode=' + str(1) + '&cat=' + urllib.quote_plus(dat['cat']) + '&name=' + urllib.quote_plus(dat['label'].encode('utf-8')) + '&search=' + urllib.quote_plus(dat['search'].encode('utf-8')) + '&page=' +urllib.quote_plus(str(dat['page']))
        liz = xbmcgui.ListItem(dat['label'], iconImage=dat['thumbnail'], thumbnailImage=dat['thumbnail'])
    
    liz.setInfo(type='video', infoLabels={'Title': dat['label'], 'plot': dat['info']['plot'], 'IMDBNumber': dat['imdbid']})
    title1 = dat['label']
    title2 = title1.split('|')
    title3 = title2[0]
    liz.setArt({ 'thumb': dat['properties']['fanart_image'],'poster': dat['properties']['fanart_image'], 'banner' : dat['properties']['fanart_image'], 'fanart': dat['properties']['fanart_image'] })
    liz.setInfo('video', { 'title': title3})
    liz.setProperty('fanart_image', dat['properties']['fanart_image'])
    liz.setProperty('IsPlayable' , dat['is_playable'])
    return xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]), url=u, listitem=liz, isFolder=False)
  else:
    add_cat(dat, 'DefaultFolder.png', 'DefaultFolder.png')

def set_viewmode():
  if __addon__.getSetting('viewset') == '':
    return
  xbmc.executebuiltin('Container.SetViewMode(%s)' % __addon__.getSetting('viewset'))

def get_params():
  param = []
  paramstring = sys.argv[2]
  if len(paramstring) >= 2:
    params = sys.argv[2]
    cleanedparams = params.replace('?', '')
    if (params[len(params) - 1] == '/'):
      params = params[0:len(params) - 2]
    pairsofparams = cleanedparams.split('&')
    param = {}
    for i in range(len(pairsofparams)):
      splitparams = {}
      splitparams = pairsofparams[i].split('=')
      if (len(splitparams)) == 2:
        param[splitparams[0]] = splitparams[1]
    return param

params = get_params()
url = None
name = None
mode = None
search = None
page = None
searchtitle = None
iconimage=None

if KodiV >= 19:
    try:
      url = urllib.parse.unquote_plus(params['url'])
    except:
      pass
    try:
      name = urllib.parse.unquote_plus(params['name'])
    except:
      pass
    try:
      mode = int(params['mode'])
    except:
      pass
    try:
      cat = urllib.parse.unquote_plus(params['cat'])
    except:
      pass
    try:
      page = urllib.parse.unquote_plus(params['page'])
    except:
      pass
    try:
      search = urllib.parse.unquote_plus(params['search'])
    except:
      pass
    try:
      searchtitle = urllib.parse.unquote_plus(params['searchtitle'])
    except:
      pass
else:
    try:
      url = urllib.unquote_plus(params['url'])
    except:
      pass
    try:
      name = urllib.unquote_plus(params['name'])
    except:
      pass
    try:
      mode = int(params['mode'])
    except:
      pass
    try:
      cat = urllib.unquote_plus(params['cat']).decode('utf-8')
    except:
      pass
    try:
      page = urllib.unquote_plus(params['page']).decode('utf-8')
    except:
      pass
    try:
      search = urllib.unquote_plus(params['search']).decode('utf-8')
    except:
      pass
    try:
      searchtitle = urllib.unquote_plus(params['searchtitle'])
    except:
      pass  

def addDir(name,url,mode,iconimage,cat,groupID):
        if KodiV >= 19:
            u=sys.argv[0]+"?url="+urllib.parse.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.parse.quote_plus(name)+"&cat="+str(cat)+"&groupID="+str(groupID)+"&iconimage="+urllib.parse.quote_plus(iconimage)
            ok=True
            liz=xbmcgui.ListItem(name)
        else:
            u=sys.argv[0]+"?url="+urllib.quote_plus(url)+"&mode="+str(mode)+"&name="+urllib.quote_plus(name)+"&cat="+str(cat)+"&groupID="+str(groupID)
            ok=True
            liz=xbmcgui.ListItem(name, iconImage=iconimage, thumbnailImage=iconimage)
        liz.setArt({ 'thumb': iconimage,'poster': iconimage, 'banner' : iconimage, 'fanart': iconimage })
        liz.setInfo( type="Video", infoLabels={ "Title": name } )
        ok=xbmcplugin.addDirectoryItem(handle=int(sys.argv[1]),url=u,listitem=liz,isFolder=True)
        return ok

def SearchedList():
    chepg(checkepg)
    searchlist = __addon__.getSetting('searchlist')
    addDir('New Search','!search!',2,__icon_search__,10,'') 
    if searchlist == '':
        pass
    else:
        matchsearch = searchlist.split(';')
        for title in matchsearch:
            addDir(title,'Search',10,__icon_sresult__,'','')
    addDir('Clear search results','Search',11,__icon_clear__,'','')
            
if mode == None or url == None or len(url) < 1:
  index_cat()
elif mode == 1:
  play_video(url, name)
elif mode == 2:
  if cat == '0':
      if search == '!search!':
          SearchedList()
      else:
          index_video(page, cat, search)
  else:
      if search == '!search!' or search == None:
        cat = '0'
        page = '0'
        keyb = xbmc.Keyboard('', 'Search')
        keyb.doModal()
        search = u'!none!'
        if keyb.isConfirmed() and len(keyb.getText().strip()) > 0 :
            search1 = keyb.getText()
            if KodiV >= 19:
                search2 = keyb.getText()
            else:
                search2 = keyb.getText().decode('utf-8')
            search = u'%s' % search2
            if searchlist == '':
                __addon__.setSetting('searchlist', search)
            else:
                matchsearch = searchlist.split(';')
                tempsearch = str(search1)
                checktitle = 0
                for title in matchsearch:
                    temptitle = str(title)
                    if tempsearch == temptitle:
                        checktitle = checktitle + 1
                    else:
                        pass
                if checktitle == 0:
                    __addon__.setSetting('searchlist', search1 + ';' + searchlist)
                else:
                    pass
            index_video(page, cat, search)
        else:
            xbmc.executebuiltin('Action(ParentDir)')
      else:
          index_video(page, cat, search)
        
elif mode == 10:
  searchtitle = name
  search = u'!none!'
  cat = '0'
  page = '0'
  if KodiV >= 19:
      search = searchtitle
  else:
      search = searchtitle.decode('utf-8')
  index_video(page, cat, search)                     

elif mode == 11:  
  __addon__.setSetting('searchlist', '')
  searchlist = __addon__.getSetting('searchlist')
  xbmc.executebuiltin('Action(ParentDir)')

if checkepg[0] == '0':
    xbmcplugin.setContent(int(sys.argv[1]), 'movies')
    set_viewmode()
else:
    xbmcplugin.setContent(int(sys.argv[1]), '')
    xbmc.executebuiltin('Container.SetViewMode(55)')
xbmcplugin.endOfDirectory(int(sys.argv[1]), cacheToDisc=False)
